
//Caption: To Design an Low Pass FIR Filter and find out the output for sine wave
//input
//Filter Length =5, Order = 4
//Window = Hamming Window
//Software version
//For: OS Windows7 and 8
//Scilab5.4.1 and above
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
//For: OS Ubuntu Linux 14.04 and above
//Scilab5.5.1 
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
clc;
clear;
xdel(winsid());
fc = input("Enter Analog cutoff freq. in Hz=")
fs = input("Enter Analog sampling freq. in Hz=")
M = input("Enter order of filter =")
w = (2*%pi)*(fc/fs);
disp(w,'Digital cutoff frequency in radians.cycles/samples');
wc = w/%pi;
disp(wc,'Normalized digital cutoff frequency in cycles/samples');
[wft,wfm,fr]=wfir('lp',M+1,[wc/2,0],'hm',[0,0]);
disp(wft,'Impulse Response of LPF FIR Filter:h[n]=');
//Plotting the Magnitude Response of LPF FIR Filter
subplot(2,1,1)
plot(2*fr,abs(wfm)/max(abs(wfm)))
xlabel('Normalized Digital Frequency w--->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR LPF')
xgrid(1)
subplot(2,1,2)
plot(fr*fs,abs(wfm)/max(abs(wfm)))
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR LPF')
xgrid(1)
t = 0:0.01:1;
f = fc;//maximum frequency of sine wave
A = 5; //Amplitude of sine wave
X = A*sin(2*%pi*f*t);
N = rand(X)
N = N/max(N)
X_N = X+N;
Y = convol(X_N,wft)
figure
subplot(3,1,1)
plot(t*f,X)
title('FIR Filter input sine wave')
xgrid(1)
subplot(3,1,2)
plot(t,X_N)
title('Random Noise+Sine Wave')
xgrid(1)
subplot(3,1,3)
t = 0:1/(length(Y)-1):1
plot(t*f,Y)
title('FIR Filter output ')
xgrid(1)
//Example
//Note: Use Low cutoff freq inorderto
//clearly visible the output waveform
//Enter Analog cutoff freq. in Hz=5
//Enter Analog sampling freq. in Hz=20
//Enter order of filter =4
//Digital cutoff frequency in radians.cycles/samples   
//    1.5707963  
//Normalized digital cutoff frequency in cycles/samples       0.5  
//Impulse Response of LPF FIR Filter:h[n]=   
//column 1 to 4
// 1.559D-18    0.1718873    0.5    0.1718873  
//column 5
// 1.559D-18  
